@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content py-3">
		<div class="container-fluid">
			<div class="card border-0 shadow-custom mb-0">
				<div class="card-header border-grey">
					<h3 class="card-title">
						{{ __('plan.update_title') }}
					</h3>
				</div>
				<form method="post" id="js-membership-type-form" action="{{ route('plan.update', $plan->id) }}">
					{{ csrf_field() }}
					<input name="_method" type="hidden" value="PATCH">
					<div class="card-body">
						<div class="row">
							<div class="col-lg-6">
								<div class="form-group">
									<label for="name">{{ __('plan.name') }}</label>
									<input type="text" value="{{ $plan->name }}"
										class="form-control @error('name') is-invalid @enderror" name="name" id="name">
									@error('name')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="amount">{{ __('plan.amount') }}</label>
									<input type="number" value="{{ $plan->amount }}"
										class="form-control @error('amount') is-invalid @enderror" name="amount"
										id="amount" placeholder="0">
									@error('amount')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-12">
								<div class="form-group">
									<label for="duration">{{ __('plan.duration') }}</label>
									<input type="number" value="{{ $plan->duration }}"
										class="form-control @error('duration') is-invalid @enderror" name="duration"
										id="duration" placeholder="{{ __('plan.membership_duration') }}">
									@error('duration')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-12">
								<div class="form-group">
									<label for="description">{{ __('plan.description') }}</label>
									<textarea rows="4" class="form-control" name="description"
										id="description">{{ $plan->description }}</textarea>
								</div>
							</div>
							<div class="col-lg-12">
								<button type="submit" class="btn btn-primary mt-1">{{ __('plan.update_plan') }}</button>
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
@endsection